<?php
require_once 'header.php';
if (!is_admin()) { echo "<div class='alert alert-danger'>مسموح للمدير فقط.</div>"; require 'footer.php'; exit; }

$msg = "";
if ($_SERVER['REQUEST_METHOD']==='POST') {
    $name = trim($_POST['full_name'] ?? '');
    $emp  = trim($_POST['employee_no'] ?? '');
    $email= trim($_POST['email'] ?? '');
    $role = $_POST['role'] ?? 'employee';
    $pass = $_POST['password'] ?? '';

    if (!$name || !$emp || !$pass) {
        $msg = "الاسم، الرقم الوظيفي، كلمة المرور مطلوبة";
    } else {
        $hash = password_hash($pass,PASSWORD_DEFAULT);
        $stmt = $mysqli->prepare("INSERT INTO safety_users(full_name,employee_no,email,password_hash,role) VALUES (?,?,?,?,?)");
        $stmt->bind_param("sssss",$name,$emp,$email,$hash,$role);
        if ($stmt->execute()) {
            $stmt->close();
            header("Location: admin_users.php");
            exit;
        } else {
            $msg = "خطأ: ربما الرقم الوظيفي أو البريد مكرر";
        }
        $stmt->close();
    }
}
?>
<h5 class="mb-3">إضافة موظف</h5>
<?php if ($msg): ?><div class="alert alert-danger"><?= htmlspecialchars($msg) ?></div><?php endif; ?>
<form method="post">
  <div class="mb-3">
    <label class="form-label">الاسم الكامل</label>
    <input type="text" name="full_name" class="form-control" required>
  </div>
  <div class="mb-3">
    <label class="form-label">الرقم الوظيفي</label>
    <input type="text" name="employee_no" class="form-control" required>
  </div>
  <div class="mb-3">
    <label class="form-label">البريد الإلكتروني (اختياري)</label>
    <input type="email" name="email" class="form-control">
  </div>
  <div class="mb-3">
    <label class="form-label">الدور</label>
    <select name="role" class="form-select">
      <option value="employee">موظف</option>
      <option value="head">رئيس قسم</option>
      <option value="admin">مدير</option>
    </select>
  </div>
  <div class="mb-3">
    <label class="form-label">كلمة المرور</label>
    <input type="password" name="password" class="form-control" required>
  </div>
  <button class="btn btn-primary">حفظ</button>
  <a href="admin_users.php" class="btn btn-secondary">رجوع</a>
</form>
<?php require 'footer.php'; ?>
