<?php
require_once 'header.php';

$today = date('Y-m-d');
$stmt = $mysqli->prepare("SELECT status,shift_name FROM safety_schedule WHERE user_id=? AND duty_date=?");
$stmt->bind_param("is", $u['id'], $today);
$stmt->execute();
$res = $stmt->get_result()->fetch_assoc();
$stmt->close();
$status = $res['status'] ?? 'غير محدد';
$shift  = $res['shift_name'] ?? '-';

// أنواع التقارير
$types = $mysqli->query("SELECT * FROM safety_report_types WHERE is_active=1 ORDER BY id")->fetch_all(MYSQLI_ASSOC);
?>
<h5 class="mb-2">مرحباً، <?= htmlspecialchars($u['full_name']) ?></h5>
<p class="text-muted">اليوم: <?= $today ?> | الحالة: <strong><?= htmlspecialchars($status) ?></strong> | الشفت: <strong><?= htmlspecialchars($shift) ?></strong></p>

<div class="row g-3 mb-4">
  <?php foreach ($types as $t): ?>
    <div class="col-6 col-md-4 col-lg-3">
      <a class="text-decoration-none" href="report_new.php?type=<?= urlencode($t['code']) ?>">
        <div class="card text-center p-3 h-100">
          <div style="font-size:30px;">📄</div>
          <div class="mt-2 fw-bold"><?= htmlspecialchars($t['label_ar']) ?></div>
          <?php if ($t['is_daily']): ?><div class="small text-success">تقرير يومي</div><?php endif; ?>
        </div>
      </a>
    </div>
  <?php endforeach; ?>
</div>

<div class="d-flex flex-wrap gap-2">
  <a href="reports_list.php" class="btn btn-outline-primary btn-sm">جميع التقارير</a>
  <?php if (is_admin()): ?>
    <a href="admin_users.php" class="btn btn-outline-secondary btn-sm">إدارة الموظفين</a>
    <a href="admin_types.php" class="btn btn-outline-secondary btn-sm">أنواع التقارير</a>
  <?php endif; ?>
  <?php if (is_head_or_admin()): ?>
    <a href="head_overview.php" class="btn btn-outline-secondary btn-sm">لوحة رئيس القسم</a>
  <?php endif; ?>
  <a href="profile.php" class="btn btn-outline-secondary btn-sm">الملف الشخصي / تصحيح دوام</a>
</div>

<?php require 'footer.php'; ?>
