<?php
require_once 'header.php';
if (!is_admin()) { echo "<div class='alert alert-danger'>مسموح للمدير فقط.</div>"; require 'footer.php'; exit; }

$msg = "";
if ($_SERVER['REQUEST_METHOD']==='POST') {
    $code = trim($_POST['code'] ?? '');
    $label= trim($_POST['label_ar'] ?? '');
    $is_daily = isset($_POST['is_daily']) ? 1 : 0;

    if (!$code || !$label) {
        $msg = "الكود والاسم مطلوبان";
    } else {
        $stmt = $mysqli->prepare("INSERT INTO safety_report_types(code,label_ar,is_daily,is_active) VALUES (?,?,?,1)");
        $stmt->bind_param("ssi",$code,$label,$is_daily);
        if ($stmt->execute()) $msg = "تمت الإضافة";
        else $msg = "خطأ: ربما الكود مكرر";
        $stmt->close();
    }
}

$res = $mysqli->query("SELECT * FROM safety_report_types ORDER BY id");
?>
<h5 class="mb-3">أنواع التقارير</h5>
<?php if ($msg): ?><div class="alert alert-info"><?= htmlspecialchars($msg) ?></div><?php endif; ?>
<form method="post" class="border p-3 mb-3">
  <div class="row g-2">
    <div class="col-md-3">
      <input type="text" name="code" class="form-control" placeholder="CODE" required>
    </div>
    <div class="col-md-5">
      <input type="text" name="label_ar" class="form-control" placeholder="اسم التقرير بالعربية" required>
    </div>
    <div class="col-md-2">
      <div class="form-check mt-1">
        <input class="form-check-input" type="checkbox" name="is_daily" id="is_daily">
        <label class="form-check-label" for="is_daily">تقرير يومي</label>
      </div>
    </div>
    <div class="col-md-2">
      <button class="btn btn-primary w-100">إضافة</button>
    </div>
  </div>
</form>

<div class="table-responsive">
<table class="table table-striped">
  <thead><tr><th>#</th><th>الكود</th><th>الاسم</th><th>يومي؟</th><th>نشط؟</th></tr></thead>
  <tbody>
    <?php while($r = $res->fetch_assoc()): ?>
      <tr>
        <td><?= $r['id'] ?></td>
        <td><?= htmlspecialchars($r['code']) ?></td>
        <td><?= htmlspecialchars($r['label_ar']) ?></td>
        <td><?= $r['is_daily'] ? 'نعم' : 'لا' ?></td>
        <td><?= $r['is_active'] ? 'نعم' : 'لا' ?></td>
      </tr>
    <?php endwhile; ?>
  </tbody>
</table>
</div>
<a href="dashboard.php" class="btn btn-secondary btn-sm">رجوع</a>
<?php require 'footer.php'; ?>
