<?php
require_once 'config.php';
if (is_logged_in()) { header("Location: dashboard.php"); exit; }

$error = "";
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $emp = trim($_POST['employee_no'] ?? '');
    $pass = $_POST['password'] ?? '';

    $stmt = $mysqli->prepare("SELECT id,full_name,employee_no,email,password_hash,role FROM safety_users WHERE employee_no=? AND is_active=1");
    $stmt->bind_param("s", $emp);
    $stmt->execute();
    $res = $stmt->get_result();
    $user = $res->fetch_assoc();
    $stmt->close();

    if (!$user || !password_verify($pass, $user['password_hash'])) {
        $error = "الرقم الوظيفي أو كلمة المرور غير صحيحة";
    } else {
        $_SESSION['user'] = $user;
        header("Location: dashboard.php");
        exit;
    }
}
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8">
<title>دخول نظام الأمن والسلامة</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-5">
  <div class="row justify-content-center">
    <div class="col-12 col-md-5">
      <div class="card p-4 shadow-sm">
        <h4 class="mb-3 text-center">تسجيل الدخول</h4>
        <?php if ($error): ?><div class="alert alert-danger"><?= htmlspecialchars($error) ?></div><?php endif; ?>
        <form method="post">
          <div class="mb-3">
            <label class="form-label">الرقم الوظيفي</label>
            <input type="text" name="employee_no" class="form-control" required>
          </div>
          <div class="mb-3">
            <label class="form-label">كلمة المرور</label>
            <input type="password" name="password" class="form-control" required>
          </div>
          <button class="btn btn-primary w-100">دخول</button>
        </form>
      </div>
    </div>
  </div>
</div>
</body>
</html>
